#ifndef DATAWHEELJOINT_H_
#define DATAWHEELJOINT_H_

#include "DataJoint.h"

namespace DataTypes
{

class DataWheelJoint : public DataTypes::DataJoint
{
public:
	DataWheelJoint(int jointid, int idbody1, int idbody2, Vector3f axis1, Vector3f axis2, float hardness, float bounciness, float maxtorque, float velocity);
	DataWheelJoint();
	virtual ~DataWheelJoint();
	Vector3f GetAxis1();
	Vector3f GetAxis2();
	float GetHardness();
	float GetBounciness();
	float GetMaxTorque();
	float GetVelocity();
	void SetAxis1(Vector3f value);
	void SetAxis2(Vector3f value);
	void SetHardness(float value);
	void SetBounciness(float value);
	void SetMaxTorque(float value);
	void SetVelocity(float value);
	string ToString();
private:
	Vector3f axis1;
	Vector3f axis2;
	float hardness;
	float bounciness;
	float maxtorque;
	float velocity;
};

}

#endif /*DATAWHEELJOINT_H_*/
